library('deSolve')

# function defining the derivative of N1 with respect to t
dN1dt <- function(t,N1,parms)
  with(parms,
       return(list(r*N1*(1-N1/K)-gamma*N1^2/(h^2+N1^2))))

# define time steps and parameter values
ts = 0:30
parms = list(r=0.6,K=100,h=5,gamma=10)	
# define the different initial conditions we will use
N1_inits = seq(10,30,2)

# run a loop: do one integration for each initial condition
for ( i in 1:length(N1_inits) )
  {
  # generate the time series
  temp = ode(N1_inits[i],ts,dN1dt,parms)
  if ( i == 1)
    {
    # create a new plot if this is the first time series
    plot(temp[,1],temp[,2],xlab='t',ylab='N1',type='l',
         ylim=c(0,80))
    }
  else
    {
    # otherwise draw the trajectory on the existing plot
    lines(temp[,1],temp[,2])
    }
  } 
